\name{homology#HOMODATA#}
\alias{homology#HOMODATA#}
\title{Annotation of #ORGANISM# HomologGeneIDs by homology data of other
  organisms that have hology relationships with #ORGANISM#}
\description{
  Genes that share an arbitrary threshold level of similarity determined
  by alignment of matching bases are termed
  homologous. homology#HOMODATA# contains mappings between #ORGANISM# internal
  HomologGeneIDs used by NCBI to represent sequences and the data
  concerning genes in other organisms that have been identified to have
  homology reltationships with genes represented by the HomologGeneIDs 
}
\details{
  homology#HOMODATA# is an environment object with key and value pairs.
  Keys are HomologGeneIDs and values are lists of homoData
  objects for other organisms that have been identified to have homology
  relationships with #ORGANISM#. The list for a given internal
  HomologGeneID may have one to many homoData objects depending on
  whether homolgy relationships have been identified in only one or more
  other organisms.

  A homoData object has slots for the name of the organism (homoOrg),
  LocusLink id (homoLL), internal HomologGeneID (homoHGID), GenBank
  accession number (homoACC) of the best matching sequence, type of similarity
  (homoType. B - reciprocal best best between three or more organisms, b
  - reciprocal best match between two organisms, and c - curated
  homology relationship between two organisms), percent of identity
  (homoPS) of the alignment between the matching sequences, and a url
  (homoURL) to the source if the relationship is a curated
  orthology. The homoData objects with homoType = B or b will not have any
  value for homoURL and objects with homoType = c will not have any
  value for homoPS. 

  The value of a given slot of a homoData object can be accessed by
  using homoOrg(xxx) for the homoOrg slot of the homoData object xxx,
  for example.  

  Mappings contained in homology#HOMODATA# were based on data provided
  by HomoloGene.
  
  Homology source built: HomoloGene built date notavailable.  

  homology#HOMODATA# package built: #BUILT#
}
\references{
\url{ftp://ftp.ncbi.nih.gov/pub/HomoloGene/hmlg.ftp}
}
\examples{
    require("annotate") || stop("annotate unavailable")
    # Convert homology#HOMODATA# to a list
    xx <- as.list(homology#HOMODATA#)

    if(length(xx) > 0){
        # Gets the homology data for the first key of homology#HOMODATA#
        homodata <- xx[[1]]
        # Gets the organism name, LocusLink id, internal HomoloGene id,
        # GenBank accession number, type of similarity, percent
        # similarity, and URL for percent similarity for the first
        # homoData object in the list obtained previously
        homoOrg(homodata)
        homoLL(homodata)
        homoHGID(homodata)
        homoACC(homodata)
        homoType(homodata)
        homoPS(homodata)
        homoURL(homodata)
        # Gets the values for more than one keys
        xx[1:3]
    }
}
\keyword{datasets}

